<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('telegram_users', function (Blueprint $table) {
            $table->id();
            $table->string('chat_id')->unique();
            $table->string('username')->nullable();
            $table->string('first_name')->nullable();
            $table->string('last_name')->nullable();
            $table->boolean('is_blocked')->default(false);
            $table->boolean('is_admin')->default(false);
            $table->string('current_state')->default('main_menu');
            $table->timestamps();
        });

        Schema::create('user_investments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('telegram_user_id')->constrained()->onDelete('cascade');
            $table->decimal('amount', 15, 2);
            $table->string('crypto_type')->nullable();
            $table->string('status')->default('pending'); // pending, approved, completed
            $table->text('transaction_proof')->nullable();
            $table->timestamps();
        });

        Schema::create('broadcasts', function (Blueprint $table) {
            $table->id();
            $table->text('message');
            $table->string('media_type')->nullable(); // photo, video, document
            $table->text('media_path')->nullable();
            $table->integer('sent_count')->default(0);
            $table->integer('failed_count')->default(0);
            $table->timestamp('sent_at')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('broadcasts');
        Schema::dropIfExists('user_investments');
        Schema::dropIfExists('telegram_users');
    }
};