<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class TelegramUser extends Model
{
    protected $fillable = [
        'chat_id',
        'username',
        'first_name',
        'last_name',
        'is_blocked',
        'is_admin',
        'current_state'
    ];

    protected $casts = [
        'is_blocked' => 'boolean',
        'is_admin' => 'boolean',
    ];

    public function investments(): HasMany
    {
        return $this->hasMany(UserInvestment::class);
    }

    public function isAdmin(): bool
    {
        return (bool) $this->is_admin;
    }

    public function updateState(string $state): void
    {
        $this->update(['current_state' => $state]);
    }
}